#!/usr/bin/python
# -*- coding: utf-8 -*-
import os
import sqlite3
import csv
import time
import sys
from random import randint

mainDirectory="/Users/Avish/Desktop/CCA Python 1/"
os.chdir(mainDirectory)


import generateDatabase


#Open Files

data =csv.reader(open(r'C:\Users\Avish\Desktop\CCA Python 1\Python INPUT\shipments9.csv', 'r'))

print ("--------------------------------------------------------------------------------- ");
print ("--------------------------------------------------------------------------------- ");
print ("Information: Importing Shipment Information");
data2 =csv.reader(open(r'C:\Users\Avish\Desktop\CCA Python 1\Python INPUT\vendors.csv', 'r'))
print ("Information: Importing Vendor Information");
data3 =csv.reader(open(r'C:\Users\Avish\Desktop\CCA Python 1\Python INPUT\customers.csv', 'r'))
print ("Information: Importing Customer Information");
print ("--------------------------------------------------------------------------------- ");
print ("--------------------------------------------------------------------------------- ");

#Connect to created Database
conn = sqlite3.connect('CCA.db')

#Insert Exported SAP CSV file data into created CCA Database, Table CCASHIPMENTS
conn.executemany("INSERT INTO CCASHIPMENTS(REFERENCE, OTHER_REFERENCE, SHIPMENT_DATE, PALLET_COUNT, CUST, CUST_ADDRESS, DELIVERY_NUM, SOLD_TO, TPPT, FWDING_AGENT, PROC_TIME, SHIP_TYPE, SHIP_COMP, SUBSNO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", data)
print ("Information: Shipments Imported and Inserted Successfully");

#Insert Exported VENDORS lookup CSV file data into created CCA Database, Table CCAVENDORS
conn.executemany("INSERT INTO CCAVENDORS(SAP_FWDING, TPPT, CUSTCHEP_ID) VALUES (?, ?, ?)", data2)
print ("Information: Vendors Imported and Inserted Successfully");

#Insert Exported CUSTOMERS lookup CSV file data into created CCA Database, Table CCAOUTLETS
conn.executemany("INSERT INTO CCAOUTLETS(OUTLET, SAP_FWDING, OUTLETCHEP_ID) VALUES (?, ?, ?)", data3)
print ("Information: Customers Imported and Inserted Successfully");

print ("--------------------------------------------------------------------------------- ");

#Print out Database information

print("Information within the database is correct as at: ", time.strftime("%d/%m/%Y"), time.strftime("%I:%M:%S"), "\n")
print ("--------------------------------------------------------------------------------- ");


#Print out Customer information
#cursor = conn.execute ("SELECT CUSTOMER, CUSTCHEP_ID from CCACUSTOMERS order by CUSTOMER")

#for row in cursor: print ("Customer =" , row[0], "CHEP Global-ID =" , row[1])

################################################################################################
'''
#Inner Join between CCASHIPMENTS AND CCACUSTOMERS + Store Join result into CHEPINFO Table

cursor = conn.execute("SELECT ship.REFERENCE, ship.OTHER_REFERENCE, ship.SHIPMENT_DATE, ship.PALLET_COUNT, ship.CUST, ship.SOLD_TO, custtable.CUSTCHEP_ID FROM CCASHIPMENTS ship INNER JOIN CCACUSTOMERS custtable ON ship.SOLD_TO = custtable.CUSTOMER_SAP_ID")
conn.executemany("INSERT INTO CHEPINFO(REFERENCE, OTHER_REFERENCE, SHIPMENT_DATE, PALLET_COUNT, CUST, CUSTOMER_SAP, CUSTCHEP_ID) VALUES (?, ?, ?, ?, ?, ?, ?)", cursor)
'''
################################################################################################
#Removing irrelevant shipments from SAP Exported Data
cursor = conn.execute("DELETE FROM CCASHIPMENTS where SHIP_TYPE =='Y009' OR SHIP_TYPE =='Y012' OR SHIP_TYPE =='Y013' OR SHIP_TYPE =='Y017'")
print ("Information: Removing non-applicable Shipments. - Filtered by Shipment Type ");
print ("--------------------------------------------------------------------------------- ");
print ("--------------------------------------------------------------------------------- ");


################################################################################################
#SHIPMENT PROCESSING STATEMENTS FOR VENDORS

print ("Information: Starting - Decision-making process for Vendors ");

cursor = conn.execute("SELECT ship.REFERENCE, ship.OTHER_REFERENCE, ship.SHIPMENT_DATE, ship.PALLET_COUNT,ship.CUST, ship.CUST_ADDRESS, vend.CUSTCHEP_ID, ship.PROC_TIME from CCASHIPMENTS ship, CCAVENDORS vend where (ship.TPPT = vend.TPPT) AND (ship.FWDING_AGENT = vend.SAP_FWDING) group by REFERENCE")
conn.executemany("INSERT INTO CHEPINFO(REFERENCE, OTHER_REFERENCE, SHIPMENT_DATE, PALLET_COUNT, CUST, CUSTOMER_SAP, CUSTCHEP_ID, PROC_TIME) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", cursor)

print ("Information: Completed - Decision-making process for Vendors ");

################################################################################################

#OUTLET LINKING PROCESSING STATEMENTS

print ("Information: Starting - Decision-making process for Customers/Outlets ");

cursor2 = conn.execute("SELECT ship.REFERENCE, ship.OTHER_REFERENCE, ship.SHIPMENT_DATE, ship.PALLET_COUNT, ship.CUST, ship.CUST_ADDRESS, outlet.OUTLETCHEP_ID, ship.PROC_TIME from CCASHIPMENTS ship, CCAOUTLETS outlet where (ship.FWDING_AGENT = outlet.SAP_FWDING) AND (ship.SOLD_TO = outlet.OUTLET) group by REFERENCE")
conn.executemany("INSERT INTO CHEPINFO(REFERENCE, OTHER_REFERENCE, SHIPMENT_DATE, PALLET_COUNT, CUST, CUSTOMER_SAP, CUSTCHEP_ID, PROC_TIME) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", cursor2)

print ("Information: Completed - Decision-making process for Customers/Outlets ");
print ("--------------------------------------------------------------------------------- ");
print ("--------------------------------------------------------------------------------- ");

################################################################################################

#Inserting Header information into CHEPEXPORT

recordNum = -1;

#Calculating number of rows for CHEPEXPORT header and converting TUPLE to INT

cursor =conn.execute ("SELECT count(*) from CHEPINFO")
recordCount =cursor.fetchone();
recordCount2 =int(' '.join(map(str,recordCount)))
recordCount2 =recordCount2 + 2;

print ("Information: Pallet liability evaluation complete");

sendDate=time.strftime("%d%m%Y"); 
headerIndicator='H'
programName="CDKTF"
programVersion="1.1"

informerGLID="6400213101" #CCA GLID
countryCode="64"
randomNumber=(randint(10,99))

docketNumber= "NZBZ"+time.strftime("%d%m")+ str(randomNumber) 
customerFileRef=docketNumber 

conn.execute("INSERT INTO CHEPEXPORT(LINE_TYPE, RECORD_NUM, DOCKET_NUMBER, SENDER, RECEIVER, DOD, DOR, EFD,REF1) VALUES (?,?,?,?,?,?,?,?,?)", (headerIndicator, recordNum, recordCount2, sendDate, programName, programVersion, informerGLID, countryCode, customerFileRef))


#Inserting row 2 information into CHEPEXPORT
lineType='F';
row2ID=0;
docketNum2="DOCKETNUMBER"
sender2="SENDER"
receiver2="RECEIVER"

dod2="DOD"
dor2="DOR"
efd2="EFD"	
ref12="REF1"
ref22="REF2"
material2="MATERIAL"
quantity2="QUANTITY"

conn.execute("INSERT INTO CHEPEXPORT(LINE_TYPE, RECORD_NUM, DOCKET_NUMBER, SENDER, RECEIVER, DOD, DOR, EFD, REF1, REF2, MATERIAL, QUANTITY) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)", (lineType, row2ID,docketNum2, sender2, receiver2, dod2, dor2, efd2, ref12, ref22, material2, quantity2))

print ("Information: Header Rows inserted into CHEPEXPORT Table");
print ("--------------------------------------------------------------------------------- ");
print ("--------------------------------------------------------------------------------- ");

#Inserting information into CHEPEXPORT
lineType='D';
docketNumber

date= time.strftime("%d%m%Y");
materialType= 16001;

print ("Information: Starting - Insert Applicable Shipments into CHEPEXPORT Table");

conn.execute("INSERT INTO TEMP(LINE_TYPE, DOCKET_NUMBER, DATE, SENDER, MATERIAL) VALUES (?,?,?,?,?)", (lineType,docketNumber,date,informerGLID,materialType))

#Inserting all shipments into CHEPEXPORT
cursor=conn.execute("INSERT INTO CHEPEXPORT(LINE_TYPE, RECORD_NUM, DOCKET_NUMBER, SENDER, RECEIVER, DOD, DOR, EFD, REF1, REF2, MATERIAL, QUANTITY) select temp.LINE_TYPE, chepinfo.LINENO,temp.DOCKET_NUMBER || chepinfo.LINENO || ('A'),temp.SENDER, chepinfo.CUSTCHEP_ID,temp.DATE, temp.DATE, temp.DATE,chepinfo.REFERENCE, chepinfo.OTHER_REFERENCE, temp.MATERIAL, chepinfo.PALLET_COUNT from chepinfo, TEMP")

print ("Information: Completed - Insert Applicable Shipments into CHEPEXPORT Table");
print ("--------------------------------------------------------------------------------- ");
print ("--------------------------------------------------------------------------------- ");

#Manual modification of RecordNum due to limitations of AUTO_INCREMENT function

cursor=conn.execute("UPDATE CHEPEXPORT set RECORD_NUM = RECORD_NUM + 2 ")

############## CALCULATING TOTAL PALLET COUNT ##############

print ("Information: Calculating number of pallets to be transferred out");

cursor = conn.execute ("SELECT sum(QUANTITY) from CHEPEXPORT")
palletCV1=cursor.fetchone()[0];
palletCV1=int(palletCV1)

print("Information:",palletCV1,"pallets transferred out")
print ("--------------------------------------------------------------------------------- ");
print ("--------------------------------------------------------------------------------- ");


############## CSV EXPORTER ##############

with sqlite3.connect("CCA.db") as connection:
    file =open("CHEP_EXPORT.csv", "w", newline='')
    csvWriter =csv.writer(file)
    connection =cursor.execute("select * from CHEPEXPORT")
    info =connection.fetchall()

csvWriter.writerows(info)
file.close()

print("Information: Starting - Generate Exportable CSV File")
print("Information: Completed - Generate Exportable CSV File")
print ("--------------------------------------------------------------------------------- ");
print ("--------------------------------------------------------------------------------- ");



############## CLOSING DATABASE ##############
conn.commit();
conn.close();	
################################################


############## EMAILER ##############

print("Information: Email is currently being prepared")
import exportEmailer
print("Information: Email has been sent")

print("Information: Pallet Liability Transfer Process Completed")
print ("--------------------------------------------------------------------------------- ");
print ("--------------------------------------------------------------------------------- ");


#######################################

#Additional functions are listed below if required.
#Please comment out the functions if you wish to use them


####### SEARCH BY CUSTOMER NAME ########
'''
customerSearch= input("Enter customer name: ")
customerSearch = customerSearch.upper();

cursor = conn.execute("SELECT REFERENCE FROM CCASHIPMENTS where CUST=?", (customerSearch,))
VALUES1=cursor.fetchall();

VALUES2 = (' '.join(map(str,VALUES1)))

print("References =",VALUES2)
'''	

####### CLEARING TABLES #############
'''

cursor=conn.execute("delete from TEMP")
print("Information: TEMP Table cleared")

cursor=conn.execute("delete from CHEPINFO")
print("Information: CHEPINFO Table cleared")

cursor=conn.execute("delete from CHEPEXPORT")
print("Information: CHEPEXPORT Table cleared")

'''
